#!/usr/bin/perl
##############################################################################
##
##  track-time.pl -- tracklist time calculator
##  2013 (c) Vladi Belperchinov-Shabanski "Cade"
##  <cade@bis.bg> <cade@biscom.net> <cade@cpan.org>
##
##  LICENSE: GPLv2, see README file for more info
##
##############################################################################
use strict;

my $time;
my $offset;
my $title;

while(<>)
  {
  if( /\bside\s*[A-Z0-9]\b/i )
    {
    report_time();
    print "\n$_";
    print '=' x length( $_ ) . "\n";
    $time = 0;
    $offset = 0;
    }
  if( /(\d+):(\d+)/ )
    {
    my $m = $1;
    my $s = $2;
    $time += $m * 60 + $s;
    print sprintf "%6d:%02d", $m, $s;
    
    my $om = int( $offset / 60 );
    my $os = int( $offset % 60 );
    print sprintf "%6s:%02d", "+$om", $os;
    $offset += $m * 60 + $s;
    
    print " -- $_";
    next;
    }
  }
report_time();

sub report_time
{
  return if $time == 0;

  my $m = int( $time / 60 );
  my $s = int( $time % 60 );
  
  print sprintf "%6d:%02d\n", $m, $s;
}

###EOF########################################################################
